#!/usr/bin/env python
# coding: utf-8

# In[ ]:


# Target class
class Target(object):

    def __init__(self, init_state, noise, time_step):
        # the location/state of target
        self.state = np.array(init_state)
        # the trajectory of target
        self.traj = [np.array(init_state)]
        # moving direction
        self.u = np.array([10.0, 0])
        # distance to the closest agent
        self.min_dist = math.inf   
        self.dist_hist =[]  
        # record reward
        self.reward_hist=[]
        # noise is a 2D vector for np.array([0.2,0.1])
        self.noise=noise
        self.time_step = time_step
    
    def update_distance(self,agents):
        self.min_dist=min([np.linalg.norm( self.state - ag.state) for ag in agents])
        self.dist_hist.append(self.min_dist)
    
    def record_reward(self,agents):
        P=np.diag((self.noise*self.time_step)**2)
        Information=2*np.diag(1/(self.noise*self.time_step)**2)
        Matrix1=np.zeros((2,2))
        for ag in agents:
            Matrix1+=(P+(ag.state-self.state).reshape(2,1).dot((ag.state-self.state).reshape(1,2)))/0.01
        Matrix1+=Information
        self.reward_hist.append(0.5*np.trace(P)-np.trace(np.linalg.inv(Matrix1)))


    def update_state(self):
        self.u=self.noise*np.random.randn(2)
        self.state =self.state+ self.u*self.time_step

